/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;

public class StoveRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ItemStack container;
    private final NonNullList<Ingredient> ingredients;
    private final Float experience;
    private final Integer cookTime;
    private final boolean needPot;

    public StoveRecipe(ResourceLocation id, ItemStack output, ItemStack container, NonNullList<Ingredient> ingredients, Float experience, Integer cookTime, Boolean needPot) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
        this.container = container;
        this.experience = experience;
        this.cookTime = cookTime;
        this.needPot = needPot;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public Integer getCookTime() {
        return this.cookTime;
    }

    public Boolean getNeedPot() {
        return this.needPot;
    }

    public NonNullList<ItemStack> getRemainingItems(SimpleContainer p_44004_) {
        return super.m_7457_((Container)p_44004_);
    }

    public boolean matches(SimpleContainer inventory, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ItemStack inputContainer = inventory.m_8020_(9);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = inventory.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && RecipeMatcher.findMatches(inputs, this.ingredients) != null && this.container.m_41720_() == inputContainer.m_41720_();
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess access) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<StoveRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("festival_delicacies", "stove");

        public StoveRecipe fromJson(ResourceLocation location, JsonObject json) {
            NonNullList<Ingredient> ingredients = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for stove recipe! The max is 9");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            boolean needPot = GsonHelper.m_13855_((JsonObject)json, (String)"needpot", (boolean)false);
            return new StoveRecipe(location, output, container, ingredients, Float.valueOf(experience), cookTime, needPot);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public StoveRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            ItemStack container = buffer.m_130267_();
            float experience = buffer.readFloat();
            int cookTime = buffer.m_130242_();
            boolean needPot = buffer.readBoolean();
            return new StoveRecipe(id, container, output, (NonNullList<Ingredient>)inputItemsIn, Float.valueOf(experience), cookTime, needPot);
        }

        public void toNetwork(FriendlyByteBuf buffer, StoveRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130055_(recipe.container);
            buffer.writeFloat(recipe.experience.floatValue());
            buffer.m_130130_(recipe.cookTime.intValue());
            buffer.writeBoolean(recipe.needPot);
        }
    }

    public static class Type
    implements RecipeType<StoveRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "stove";

        private Type() {
        }
    }
}

